#ifndef _COMMERCE_H
#define _COMMERCE_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	// Structure for returning category info.
	struct CommerceCategoryInfo
	{
		const char* categoryId;				// The ID of the subcategory.
		const char* categoryName;			// The name of the subcategory.
		const char* categoryDescription;	// The detailed description of the subcategory.
		const char* imageUrl;				// The image URL of the subcategory.
		int countOfProducts;				// The number of products in the category, always 0 for sub-categories.
		int countOfSubCategories;			// The number of subcategories, always 0 for sub-categories.
	};

	// Structure for returning product info.
	struct CommerceProductInfo
	{
		UInt32 purchasabilityFlag;			// A flag that indicates whether the product can be purchased (<c>SCE_NP_COMMERCE2_SKU_PURCHASABILITY_FLAG_XXX</c>).
		const char* productId;				// The product ID.
		const char* productName;			// The name of the product.
		const char* shortDescription;		// A short description of the product.
		const char* spName;					// The service provider name.
		const char* imageUrl;				// The product image URL.
		const char* price;					// The price of the product. This is formatted to include the currency code.	
		UInt64 releaseDate;					// The product release date.
	};

	// Structure for returning detailed product info.
	struct CommerceProductInfoDetailed
	{
		UInt32 purchasabilityFlag;			// A flag that indicates whether the product can be purchased (<c>SCE_NP_COMMERCE2_SKU_PURCHASABILITY_FLAG_XXX</c>).
		const char* skuId;					// The SKU ID
		const char* productId;				// The product ID.
		const char* productName;			// The name of the product.
		const char* shortDescription;		// A short description of the product.
		const char* longDescription;		// A long description of the product.
		const char* legalDescription;		// The legal description for the product.	
		const char* spName;					// The service provider name.
		const char* imageUrl;				// The product image URL.
		const char* price;					// The price of the product. This is formatted to include the currency code.
		const char* ratingSystemId;			// The ID of the rating system (for example: PEGI, ESRB).
		const char* ratingImageUrl;			// The URL of the rating icon.
		UInt64	releaseDate;				// The product release date.
		int numRatingDescriptors;			// The number of rating descriptors stored for this product.
	};

	struct CommerceEntitlement
	{
		const char* id;
		int type;
		int remainingCount;  /* may be negative */
		UInt32 consumedCount;
		UInt64 createdDate;
		UInt64 expireDate;
	};
	
	//		sce::Toolkit::NP::Utilities::Future<std::vector<SceNpEntitlement> > m_EntitlmentList;
	//typedef struct SceNpCommerce2CommonData_
	//{
	//	SceUInt32 version;
	//	const SceUChar8 *buf_head;
	//	const SceUChar8 *buf_size;
	//	const SceUChar8 *data;
	//	SceSize data_size;
	//	const SceUChar8 *data2;
	//	unsigned int ov;
	//	SceUInt32 reserved[16];
	//} SceNpCommerce2CommonData;

	//typedef struct SceNpCommerce2ContentRatingDescriptor_
	//{
	//	SceNpCommerce2CommonData commonData;

	//	/* value */
	//	SceUInt32 descriptorType;
	//	const char *imageUrl;                  /* valid only if descType is icon */
	//	const char *contentRatingDescription;  /* valid only if descType is text */
	//	SceUInt32 reserved[8];
	//} SceNpCommerce2ContentRatingDescriptor;

	PRX_EXPORT bool PrxCommerceIsBusy();
	PRX_EXPORT bool PrxCommerceGetLastError(ResultCode* result);

	PRX_EXPORT ErrorCode PrxCommerceCreateSession();

	PRX_EXPORT ErrorCode PrxCommerceBrowseCategory(const char *categoryId);
	PRX_EXPORT ErrorCode PrxCommerceBrowseProduct(const char* productId);
	PRX_EXPORT ErrorCode PrxCommerceDisplayDownloadList();
	PRX_EXPORT ErrorCode PrxCommerceCheckout(char** skuIDs, int count);
	PRX_EXPORT ErrorCode PrxCommerceVoucherInput();

	PRX_EXPORT ErrorCode PrxCommerceRequestCategoryInfo(const char *categoryId);
	PRX_EXPORT ErrorCode PrxCommerceGetCategoryInfo(CommerceCategoryInfo* categoryInfo);
	PRX_EXPORT ErrorCode PrxCommerceGetSubCategoryInfo(UInt32 index, CommerceCategoryInfo* categoryInfo);

	PRX_EXPORT ErrorCode PrxCommerceRequestProductList(const char *categoryId);
	PRX_EXPORT int PrxCommerceGetProductListInfoCount();
	PRX_EXPORT ErrorCode PrxCommerceGetProductListInfoItem(UInt32 index, CommerceProductInfo* productInfo);

	PRX_EXPORT ErrorCode PrxCommerceRequestDetailedProductInfo(const char* productId);
	PRX_EXPORT ErrorCode PrxCommerceGetProductInfoDetailed(CommerceProductInfoDetailed* productInfo);

	PRX_EXPORT ErrorCode PrxCommerceRequestEntitlementList();
	PRX_EXPORT int PrxCommerceGetEntitlementListCount();
	PRX_EXPORT ErrorCode PrxCommerceGetEntitlementListItem(UInt32 index, CommerceEntitlement* entitlement);

	PRX_EXPORT ErrorCode PrxCommerceConsumeEntitlement(const char* entitlementId, int consumeCount);

	PRX_EXPORT bool PrxCommerceShowStoreIcon(bool show, int position);

	class CachedCommerce
	{
		SimpleLock m_Lock;
		bool m_Busy;
		bool m_SessionCreated;
		sys_memory_container_t m_CheckoutDlgMemContainer;
		sys_memory_container_t m_DlListDlgMemContainer;
		sys_memory_container_t m_BrowseProductDlgMemContainer;
		sys_memory_container_t m_VoucherInputDlgMemContainer;

		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::CategoryInfo> m_CategoryInfo;
		sce::Toolkit::NP::Utilities::Future<std::vector<sce::Toolkit::NP::ProductInfo> > m_ProductList;
		sce::Toolkit::NP::Utilities::Future<std::vector<SceNpEntitlement> > m_EntitlmentList;
		sce::Toolkit::NP::Utilities::Future<sce::Toolkit::NP::ProductInfoDetailed> m_ProductInfo;

		ResultCode m_LastResult;

	public:
		CachedCommerce();
		~CachedCommerce();

		bool ProcessEvent(const sce::Toolkit::NP::Event& event);

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }

		void Update();

		ErrorCode CreateSession();

		ErrorCode BrowseCategory(const char* categoryId);
		ErrorCode BrowseProduct(const char* productId);
		ErrorCode DisplayDownloadList();
		ErrorCode Checkout(char** skuIDs, int count);
		ErrorCode VoucherInput();

		ErrorCode RequestCategoryInfo(const char* categoryId);
		ErrorCode GetCategoryInfo(CommerceCategoryInfo* categoryInfo);
		ErrorCode GetSubCategoryInfo(UInt32 index, CommerceCategoryInfo* categoryInfo);

		ErrorCode RequestProductList(const char* categoryId);
		int GetProductListInfoCount();
		ErrorCode GetProductListInfoItem(UInt32 index, CommerceProductInfo* productInfo);

		ErrorCode RequestDetailedProductInfo(const char* productId);
		ErrorCode GetProductInfoDetailed(CommerceProductInfoDetailed* productInfo);

		ErrorCode RequestEntitlementList();
		int GetEntitlementListCount();
		ErrorCode GetEntitlementListItem(UInt32 index, CommerceEntitlement* entitlement);

		ErrorCode ConsumeEntitlement(const char* entitlementId, int consumeCount);

		void CleanupDialogMem();

//		bool GetProductInfoRatingsDescriptor(UInt32 index);
	};

	extern CachedCommerce gCommerce;
}

#endif // _COMMERCE_H
